Attribute VB_Name = "FEISC"
'---------------------------------------------------------
'|                                                       |
'|                      FEISC.BAS                        |
'|                                                       |
'---------------------------------------------------------
'
'Copyright  2000-2006  FEIG ELECTRONIC GmbH, All Rights Reserved.
'                       Lange Strasse 4
'                       D-35781 Weilburg
'                       Federal Republic of Germany
'                       phone    : +49 6471 31090
'                       fax      : +49 6471 310999
'                       e-mail   : info@feig.de
'                       Internet : http://www.feig.de
'
'Version              : 05.04.11 / 07.09.2006 / M. Hultsch
'
'Operation Systems    : Windows 9x/ME/NT/2000/XP
'
'
'This File contains the constants, datatypes and function declarations of FEISC.DLL

Option Explicit


' constants for uiFlag in FEISC_MSG_INIT
Public Const FEISC_THREAD_ID = 1        'not possible in Visual Basic
Public Const FEISC_WND_HWND = 2         'not possible in Visual Basic
Public Const FEISC_CALLBACK = 3         'not possible in Visual Basic
Public Const FEISC_EVENT = 4
Public Const FEISC_CALLBACK_2 = 5

' defines for uiUse in FEISC_MSG_INIT
Public Const FEISC_PRT_EVENT = 1
Public Const FEISC_SNDPRT_EVENT = 2
Public Const FEISC_RECPRT_EVENT = 3
Public Const FEISC_SCANNER_EVENT = 4

' structure for transfering callback functions
Type FEISC_EVENT_INIT
        uiUse   As Long         ' defines the event (e.g. FEISC_PRT_EVENT)
        uiMsg   As Long         ' set always to 0 - in Visual Basic not necessary !!
        uiFlag  As Long         ' set always to FEISC_EVENT
        Method  As Long         ' for callback-function or event-handle
End Type


' miscellaneous functions
Public Declare Sub FEISC_GetDLLVersion Lib "FEISC.DLL" (ByVal cVersion As String)
Public Declare Function FEISC_GetErrorText Lib "FEISC.DLL" (ByVal iErrorCode As Long, ByVal cErrorText As String) As Long
Public Declare Function FEISC_GetStatusText Lib "FEISC.DLL" (ByVal ucStatus As Byte, ByVal cStatusText As String) As Long

' functions for event notification
Public Declare Function FEISC_AddEventHandler Lib "FEISC.DLL" (ByVal iReaderHnd As Long, pInit As FEISC_EVENT_INIT) As Long
Public Declare Function FEISC_DelEventHandler Lib "FEISC.DLL" (ByVal iReaderHnd As Long, pInit As FEISC_EVENT_INIT) As Long

' administration functions
Public Declare Function FEISC_NewReader Lib "FEISC.DLL" (ByVal iPortHnd As Long) As Long
Public Declare Function FEISC_DeleteReader Lib "FEISC.DLL" (ByVal iReaderHnd As Long) As Long
Public Declare Function FEISC_GetReaderList Lib "FEISC.DLL" (ByVal iNext As Long) As Long
Public Declare Function FEISC_GetReaderPara Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cPara As String, ByVal cValue As String) As Long
Public Declare Function FEISC_SetReaderPara Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cPara As String, ByVal cValue As String) As Long
                                                                                                        
' functions for protocol frame
Public Declare Function FEISC_BuildSendProtocol Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cCmdByte As Byte, ByVal cSendData As String, ByVal iDataLen As Long, ByVal cSendProt As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_SplitRecProtocol Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cRecProt As String, ByVal iRecLen As Long, cBusAdr As Byte, cCmdByte As Byte, ByVal cRecData As String, iDataLen As Long, ByVal iDataType As Long) As Long
                                                                                                        
' query functions
Public Declare Function FEISC_GetLastSendProt Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cSendProt As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_GetLastRecProt Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cRecProt As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_GetLastState Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cStateText As String) As Long
Public Declare Function FEISC_GetLastRecProtLen Lib "FEISC.DLL" (ByVal iReaderHnd As Long) As Long
Public Declare Function FEISC_GetLastError Lib "FEISC.DLL" (ByVal iReaderHnd As Long, iErrorCode As Long, ByVal cErrorText As String) As Long

' common communication functions
Public Declare Function FEISC_SendTransparent Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cSendProt As String, ByVal iSendLen As Long, ByVal cRecProt As String, ByVal iRecLen As Long, ByVal iCheckSum As Long, ByVal iDataType As Long) As Long
Public Declare Function FEISC_Transmit Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cSendProt As String, ByVal iSendLen As Long, ByVal iCheckSum As Long, ByVal iDataType As Long) As Long
Public Declare Function FEISC_Receive Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cRecProt As String, ByVal iRecLen As Long, ByVal iDataType As Long) As Long
                                                                                                        
' communication functions
Public Declare Function FEISC_0x18_Destroy Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cMode As Byte, ByVal cLen As Byte, cEPC As Byte, cPW As Byte) As Long
Public Declare Function FEISC_0x1A_Halt Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x1B_ResetQuietBit Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x1C_EASRequest Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x21_ReadBuffer Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cSets As Byte, cTrData As Byte, cRecSets As Byte, ByVal cRecDataSets As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x22_ReadBuffer Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal iSets As Long, cTrData As String, iRecSets As Long, ByVal cRecDataSets As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x31_ReadDataBufferInfo Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cTabSize As String, ByVal cTabStart As String, ByVal cTabLen As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x32_ClearDataBuffer Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x33_InitBuffer Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x52_GetBaud Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x55_StartFlashLoader Lib "FEISC.DLL" (ByVal iReaderHnd As Long) As Long
Public Declare Function FEISC_0x55_StartFlashLoaderEx Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x63_CPUReset Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x65_SoftVersion Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cVersion As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x66_ReaderInfo Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cMode As Byte, ByVal cVersion As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x69_RFReset Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x6A_RFOnOff Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cRF As Byte) As Long
Public Declare Function FEISC_0x6C_SetNoiseLevel Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cLevel As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x6D_GetNoiseLevel Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cLevel As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x6E_RdDiag Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cMode As Byte, ByVal cData As String) As Long
Public Declare Function FEISC_0x6F_AntennaTuning Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte) As Long
Public Declare Function FEISC_0x71_SetOutput Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal iOS As Long, ByVal iOSF As Long, ByVal iOSTime As Long, ByVal iOutTime As Long) As Long
Public Declare Function FEISC_0x72_SetOutput Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cMode As Byte, ByVal cOutN As Byte, cRecords As Byte) As Long
Public Declare Function FEISC_0x74_ReadInput Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, cInput As Byte) As Long
Public Declare Function FEISC_0x75_AdjAntenna Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cLevel As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x80_ReadConfBlock Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cConfAdr As Byte, ByVal cConfBlock As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x81_WriteConfBlock Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cConfAdr As Byte, ByVal cConfBlock As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x82_SaveConfBlock Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cConfAdr As Byte) As Long
Public Declare Function FEISC_0x83_ResetConfBlock Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cConfAdr As Byte) As Long
Public Declare Function FEISC_0x84_SetCFGMemLoc Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cMemAdr As Byte) As Long
Public Declare Function FEISC_0x85_SetSysTimer Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cTime As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x86_GetSysTimer Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cTime As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0x87_SetSystemDate Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cCentury As Byte, ByVal cYear As Byte, ByVal cMonth As Byte, ByVal cDay As Byte, ByVal cTimezone As Byte, ByVal cHour As Byte, ByVal cMinute As Byte, ByVal iMilliSecond As Long) As Long
Public Declare Function FEISC_0x88_GetSystemDate Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, cCentury As Byte, cYear As Byte, cMonth As Byte, cDay As Byte, cTimezone As Byte, cHour As Byte, cMinute As Byte, iMilliSecond As Byte) As Long
Public Declare Function FEISC_0xA0_RdLogin Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cRd_PW As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0xA2_WriteMifareKeys Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cType As Byte, ByVal cAdr As Byte, ByVal cKey As String, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0xB0_ISOCmd Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cReqData As String, ByVal iReqLen As Long, ByVal cRspData As String, iRspLen As Long, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0xB1_ISOCustAndPropCmd Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cMfr As Byte, ByVal cReqData As String, ByVal iReqLen As Long, ByVal cRspData As String, iRspLen As Long, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0xB2_ISOCmd Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cReqData As String, ByVal iReqLen As Long, ByVal cRspData As String, iRspLen As Long, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0xB3_EPCCmd Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal cReqData As String, ByVal iReqLen As Long, ByVal cRspData As String, iRspLen As Long, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0xBD_ISOTranspCmd Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal iMode As Long, ByVal iRspLength As Long, ByVal cReqData As String, ByVal iReqLen As Long, ByVal cRspData As String, iRspLen As Long, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0xBE_ISOTranspCmd Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal iMode As Long, ByVal iRspLength As Long, ByVal cReqData As String, ByVal iReqLen As Long, ByVal cRspData As String, iRspLen As Long, ByVal iDataType As Long) As Long
Public Declare Function FEISC_0xBF_ISOTranspCmd Lib "FEISC.DLL" (ByVal iReaderHnd As Long, ByVal cBusAdr As Byte, ByVal iMode As Long, ByVal iRspLength As Long, ByVal cReqData As String, ByVal iReqLen As Long, ByVal cRspData As String, iRspLen As Long, ByVal iDataType As Long) As Long

